import type {AsyncData, UseFetchOptions} from 'nuxt/app';
import {FetchError} from "ofetch";
import type {DefaultAsyncDataErrorValue} from "#app/defaults";
// @ts-ignore
import type {PickFrom} from "nuxt/dist/app/composables/asyncData";

export function useF<T>(
    url: string | (() => string),
    options: UseFetchOptions<T> = {}
): AsyncData<PickFrom<T, Array<keyof T extends string ? keyof T : never>> | null, DefaultAsyncDataErrorValue | FetchError> {
    const nuxtApp = useNuxtApp();

    return useFetch(url, {
        method: 'GET',
        // @ts-ignore
        baseURL: nuxtApp?.$settings?.apiUrl,
        responseType: 'json',
        parseResponse: (res) => JSON.parse(res),
        immediate: true,
        watch: false,

        ...options,
        // @ts-ignore
        $fetch: nuxtApp.$f,
    })
}