import type {INuxtApp, TNuxtApp} from "@/types/app-d-t";
import type {ILocale} from "@/types/locale-d-t";

export function useSiteSettings() {
    const nuxtApp: TNuxtApp = useNuxtApp();
    const $settings = (nuxtApp as INuxtApp)?.$settings
    const $i18n = (nuxtApp as INuxtApp)?.$i18n

    const getDefaultNoImageUrl = () => $settings?.noImageUrl || "";
    const title = (title: string = '', page?: number, separator: string = ' - ') => {
        if (title && page) {
            title = `${title}${separator}` + $i18n?.t("Page :number", {number: page});
        }
        return title;
    };


    return {
        settings: $settings,
        locales: ($settings?.locales || []) as ILocale[],
        locale: String($settings?.locale || ''),

        getDefaultNoImageUrl,
        title,
    };
}
