// https://nuxt.com/docs/api/configuration/nuxt-config
const silenceSomeSassDeprecationWarnings = {
    verbose: true,
    logger: {
        warn(message: string, options: any) {
            return;
            // const {stderr} = process;
            // const span = options.span ?? undefined;
            // const stack = (options.stack === 'null' ? undefined : options.stack) ?? undefined;
            //
            // if (options.deprecation) {
            //     if (message.startsWith('Using / for division outside of calc() is deprecated')) {
            //         // silences above deprecation warning
            //         return;
            //     }
            //     stderr.write('DEPRECATION ');
            // }
            // stderr.write(`WARNING: ${message}\n`);
            //
            // if (span !== undefined) {
            //     // output the snippet that is causing this warning
            //     stderr.write(`\n"${span.text}"\n`);
            // }
            //
            // if (stack !== undefined) {
            //     // indent each line of the stack
            //     stderr.write(`    ${stack.toString().trimEnd().replace(/\n/gm, '\n    ')}\n`);
            // }
            //
            // stderr.write('\n');
        }
    }
};

export default defineNuxtConfig({
    runtimeConfig: {
        public: {
            googleMap: process.env.NUXT_ENV_GOOGLE_MAP || "",
            stripePublishableKey: process.env.VITE_STRIPE_PUBLISHABLE_KEY,
            apiUrl: process.env.NUXT_ENV_API_URL || "",

            noImageUrl: process.env.NUXT_ENV_NO_IMAGE_URL || "/images/no-image.png",
            baseUrl: process.env.NUXT_PUBLIC_BASE_URL || "",
            perPage: process.env.NUXT_ENV_PER_PAGE || '9',
            perRow: process.env.NUXT_ENV_PER_ROW || '3',
            siteTitle: process.env.NUXT_ENV_SITE_TITLE || "Shop1",
            updateSlugOnLocale: process.env.NUXT_ENV_UPDATE_SLUG_ON_LOCALE ?? '',
        }
    },

    vite: {
        css: {
            preprocessorOptions: {
                scss: {
                    ...silenceSomeSassDeprecationWarnings,
                    api: 'modern-compiler',
                    quietDeps: true
                },
                sass: {
                    ...silenceSomeSassDeprecationWarnings,
                    api: 'modern-compiler',
                    quietDeps: true
                },
            },
        },
    },

    purgecss: {
        enabled: false,
        safelist: [],
    },

    i18n: {
        strategy: "no_prefix",
        locales: [
            {
                code: 'en',
                language: 'en-US',
                name: 'en',
                dir: 'ltr',
                // file: 'en.json'
            },
            {
                code: 'ar',
                language: 'ar-SA',
                name: 'ar',
                dir: 'rtl',
                // file: 'ar.json'
            },
        ],
        defaultLocale: "en",
        detectBrowserLanguage: {
            useCookie: true,
            cookieKey: 'i18n_redirected'
        },
        vueI18n: "./i18n.config.ts",
        // lazy: true,
        // langDir: 'locales',
    },

    app: {
        baseURL: '/',
        head: {
            title: "",
            charset: 'utf-8',
            viewport: 'width=device-width, initial-scale=1',
            base: {href: '/'},
            script: [
                {
                    src: "/js/jquery-3.2.1.slim.min.js",
                },
                {
                    src: "/js/bootstrap.bundle.min.js",
                },
            ],
        },
    },

    css: [
        "bootstrap/scss/bootstrap.scss",
        "swiper/css/bundle",
        "@/assets/css/font-awesome-pro.css",
        // "@/assets/css/flaticon_shofy.css",
        "@/assets/scss/main.scss",
    ],

    modules: [
        [
            '@pinia/nuxt',
            {
                autoImports: [
                    'defineStore',
                    ['defineStore', 'definePiniaStore'],
                ],
            },
        ],
        '@nuxtjs/i18n',
        "vue3-carousel-nuxt",
        'nuxt-purgecss'
    ],

    plugins: [
        // {src: "~/plugins/loadingIndicator.ts", mode: "all", order: -1},
        {src: "~/plugins/00.axiosInstance.ts", mode: "all"},
        {src: "~/plugins/01.settings.ts", mode: "all"},
        {src: "~/plugins/02.translations.ts", mode: "all"},
        {src: "~/plugins/api.ts", ssr: false},
        {src: "~/plugins/i18n.ts", mode: "all"},
        {src: "~/plugins/yupLocale.ts", mode: "client"},
    ],

    devtools: {
        enabled: false
    },

    logLevel: 'verbose', //'silent' | 'info' | 'verbose',
    debug: false,
    ssr: true,
    sourcemap: true,
    compatibilityDate: '2024-10-21',
});

