import {defineStore} from "pinia";
import {ref} from "vue";
import {api} from "@/plugins/api";
import type {IProduct} from "@/types/product-d-t";
import type {IFetchProductOptions} from "@/types/fetch-product-options-d-t";
import type {TPagination} from "@/types/pagination-d-t";
import type {IMeta} from "@/types/meta-d-t";

const _LOG = false;

export const useProductStore = defineStore("product", () => {
    let activeImg = ref<string>("");
    let openFilterDropdown = ref<boolean>(false);
    let openFilterOffcanvas = ref<boolean>(false);
    let currentPage = ref<number>(1); // page number value as ref
    let currentOptions = ref<IFetchProductOptions>({});
    const product_data = ref<IProduct[]>([]);
    const product_meta = ref<IMeta>({});

    const loadDefaultFetchProductOptions = () => {
        const route = useRoute();
        let slug = String(route?.params?.product).trim();
        return {
            slug,
            page: Number(currentPage.value || 1)
        };
    }

    const loadProducts = async (args?: IFetchProductOptions): Promise<IProduct[]|TPagination|TPagination<IProduct[]>> => {
        currentOptions.value = args || loadDefaultFetchProductOptions();
        _LOG && console.warn(22 + ':useProductStore', currentOptions.value)

        const _data = await api.productData(currentOptions.value);
        if (currentOptions.value?.pagination) {
            product_meta.value = (_data as TPagination)?.meta;
            product_data.value = (_data as TPagination<IProduct[]>)?.data || [];
        } else {
            product_meta.value = {};
            product_data.value = _data as IProduct[];
        }

        // activeImg.value = product_data.value?.[0]?.images?.[0] || "";
        return product_data.value// as IProduct[];
    };

    // Update current page
    const updateCurrentPage = (pageNumber: number) => {
        currentPage.value = pageNumber;
    };
    const updateProductOptions = (options: IFetchProductOptions) => {
        currentOptions.value = options;
    };

    return {
        product_data,
        product_meta,
        activeImg,
        openFilterDropdown,
        openFilterOffcanvas,
        currentPage,
        updateCurrentPage,
        currentProductOptions: currentOptions,
        updateProductOptions,
        loadProducts,
        handleImageActive: (img: string) => (activeImg.value = img),
        handleOpenFilterDropdown: () => (openFilterDropdown.value = !openFilterDropdown.value),
        handleOpenFilterOffcanvas: () => (openFilterOffcanvas.value = !openFilterOffcanvas.value),
        setData: (data: IProduct[]) => {
            try {
                product_data.value = data
            } catch (e) {
                console.error(e)
            }

            return data;
        },
        setMeta: (meta: IMeta) => {
            try {
                product_meta.value = meta
            } catch (e) {
                console.error(e)
            }

            return meta;
        },
    };
});
