import {useCartStore} from './useCartStore';
import {ref, watch} from "vue";
import {defineStore} from "pinia";
import {type IProduct, type TProducts} from '@/types/product-d-t';
// import { useProductStore } from './useProductStore';
import {useProductStore} from "@/pinia/useProductStore";
import {api} from "@/plugins/api";
import {convertProductReviewResponse} from "@/plugins/data/product-reviews-data";
import type {TPagination, TPaginationOr} from "@/types/pagination-d-t";
import type {IReview} from "@/types/review-d-t";
import type {IReviewResponse} from "@/types/review-response-d-t";
import type {TProductDataWithPagination} from "@/types/fetch-product-options-d-t";

export const useUtilityStore = defineStore("utility", () => {
    const route = useRoute();
    const productStore = useProductStore();
    const cartStore = useCartStore();
    // const product_data = computed(() => productStore.product_data);
    let openSearchBar = ref<boolean>(false);
    let openMobileMenus = ref<boolean>(false);
    // product modal
    let modalId = ref<string | null>('product-modal-641e887d05f9ee1717e1348a');
    // @ts-ignore
    let product = ref<IProduct | null>(productStore?.product_data?.value?.[0]);
    // let product = useState<IProduct | null>('product', {value: product_data.value?.[0]});
    const meta = useState('meta-utility', () => {});

    // video modal
    const videoUrl = ref<string>('https://www.youtube.com/embed/EW4ZYb3mCZk')
    const isVideoOpen: Ref<boolean> = ref(false);

    let iframeElement: HTMLIFrameElement | null = null;

    // handle image active
    const handleOpenSearchBar = () => {
        openSearchBar.value = !openSearchBar.value;

        if (openSearchBar.value) {
            setTimeout(() => {
                const userInput = document.querySelector('.search-bar-input-search');
                // @ts-ignore
                userInput?.focus();
                // @ts-ignore
                userInput?.select();
            }, 500);
        }
    };

    // handle image active
    const handleOpenMobileMenu = () => {
        openMobileMenus.value = !openMobileMenus.value;
    };
    const closeOpenMobileMenu = () => {
        openMobileMenus.value = false;
    };

    // modal video play
    const playVideo = (videoId: string) => {
        const videoOverlay = document.querySelector("#video-overlay");
        videoUrl.value = `https://www.youtube.com/embed/${videoId}`
        if (!iframeElement) {
            iframeElement = document.createElement("iframe");
            iframeElement.setAttribute("src", videoUrl.value);
            iframeElement.style.width = "60%";
            iframeElement.style.height = "80%";
        }

        isVideoOpen.value = true;
        videoOverlay?.classList.add("open");
        videoOverlay?.appendChild(iframeElement);
    };
    // close modal video
    const closeVideo = () => {
        const videoOverlay = document.querySelector("#video-overlay.open");

        if (iframeElement) {
            iframeElement.remove();
            iframeElement = null;
        }

        isVideoOpen.value = false;
        videoOverlay?.classList.remove("open");
    };

    const removeBackdrop = () => {
        try {
            const modalBackdrop = document.querySelector('.modal-backdrop');
            if (modalBackdrop) {
                modalBackdrop.remove();
                document.body.classList.remove('modal-open');
                document.body.removeAttribute('style');
            }
        } catch (error) {
            console.error(error);
        }
    };

    // handle Open Modal
    const handleOpenModal = (id: string | null, item: IProduct | null, fetchProduct: boolean = false) => {
        if (!id || !item) {
            console.warn(83, 'handleOpenModal', id, item);
            // @ts-ignore
            window?.$(`#${modalId.value}`).modal('hide');
        }

        modalId.value = id;
        product.value = item;
        productStore.handleImageActive(item ? item?.images?.[0] : "");
        cartStore.initialOrderQuantity()

        api.productReviewsData({
            product: product.value,
            plain: true,
            pagination: true,
        })
            .then(({meta: $meta}: any) => {
                meta.value = $meta;
            })

        if (fetchProduct) {
            const loading = useLoading();
            loading.disable();
            api.productData({product: item})
                .then((products) => (products as IProduct[])?.[0])
                .then((p?: IProduct) => {
                    if (p && p.id) {
                        product.value = p;
                        productStore.handleImageActive(p ? p?.images?.[0] : "");
                    }
                })
                .then(() => loading.enable())
        }
    };

    // const handleShippingCost = (value: number | string) => {
    //     if (value === 'free' || value === 0) {
    //         shipCost.value = 0;
    //     } else {
    //         shipCost.value = value as number;
    //     }
    // }

    // @ts-ignore
    watch(() => route.href, () => {
        openSearchBar.value = false;
        openMobileMenus.value = false;
    })


    return {
        handleOpenSearchBar,
        openSearchBar,
        handleOpenModal,
        modalId,
        product,
        meta,
        openMobileMenus,
        handleOpenMobileMenu,
        closeOpenMobileMenu,
        playVideo,
        isVideoOpen,
        iframeElement,
        closeVideo,
        removeBackdrop,
        // handleShippingCost,
        // shipCost,
        // fees
    };
});
