import formDataService from "@/services/formDataService";
import type {IContactUsFormValues} from "@/types/contact-us-form-values-d-t";
import type {TResponse} from "@/types/response-d-t";

export function contactUsData(data: IContactUsFormValues): Promise<TResponse> {
    try {
        return $axios.post('contact-us', formDataService(data))
    } catch (error) {
        console.error(error);
    }

    return Promise.reject({} as TResponse);
}

export default contactUsData;