import type {ICountryResponse} from "@/types/country-response-d-t";
import type {ICountry} from "@/types/country-d-t";

export async function countriesData(): Promise<ICountry[]> {
    try {
        const response: { data: { data: ICountryResponse[], default?: string } } = await $axios.get('countries');
        return (response?.data?.data || []).map(convertCountryResponse);
    } catch (error) {
        console.error('Error fetching country data:', error);
        return [] as ICountry[];
    }
}

export function convertCountryResponse(data: ICountryResponse): ICountry {
    return {
        ...data
    };
}

export default countriesData;