import type {TResponse} from "@/types/response-d-t";

export async function userLogoutData(): Promise<string> {
    try {
        return $axios
            .post('logout')
            .then((response: {data: TResponse}) => {
                return response?.data?.message || "";
            });
    } catch (error) {
        console.error(error);
        // Handle logout error
    }

    return Promise.reject("");
}

export default userLogoutData;