import type {Composer, ExportedGlobalComposer} from "vue-i18n";
// @ts-ignore
import type {NuxtI18nRoutingCustomProperties} from "@nuxtjs/i18n/dist/runtime/types";
import type {LocaleObject} from "@nuxtjs/i18n";
import type {ISiteSettings} from "@/types/site-settings-d-t";
import type {IAxios} from "@/types/axios-d-t";
import type {NuxtApp} from "nuxt/app";
import type {ILocale} from "@/types/locale-d-t";
import type {ITranslation} from "@/types/translation-d-t";

export interface INuxtApp extends NuxtApp {
    $i18n: ExportedGlobalComposer & Composer & NuxtI18nRoutingCustomProperties<LocaleObject[]>;
    $settings: ISiteSettings;
    $axios: IAxios;
    $locales: ILocale[];
    $locale: string;
    $baseUrl: string;
    $translations: ITranslation;
}

export type TNuxtApp = INuxtApp | NuxtApp;