import type {IProduct} from "@/types/product-d-t";
import type {ICategory} from "@/types/category-d-t";
import type {IBrand} from "@/types/brand-d-t";
import type {TPagination, TPaginationOr} from "@/types/pagination-d-t";
import type {AxiosResponse} from "axios";

export type IFetchProductOptions = {
    name?: string;
    prepend?: IProduct[];
    append?: IProduct[];
    page?: number;
    slug?: string;
    category?: ICategory;
    brand?: IBrand;
    search?: string;
    plain?: boolean;
    pagination?: boolean;
    toURL?: boolean;
    product?: IProduct|null,
    query?: string,
    baseUrl?: string,
};

export type TProductDataWithPagination<T = any> = string|TPaginationOr<T>;

export interface ProductDataAxiosPromise<T = any> extends Promise<AxiosResponse<TPagination<T>>> {
}