import type {IReview} from "@/types/review-d-t";
import type {ICategory} from "@/types/category-d-t";
import type {IProductResponse} from "@/types/product-response-d-t";

export interface IProduct {
    ITYPE: string;
    sku: string;
    id: number|string;
    name: string;
    ar_name?: string;
    en_name?: string;
    images: string[];
    parentCategory: ICategory;
    children: string;
    price: number;
    discount: number;
    net: number;
    quantity: number | string;
    rating: number | string| undefined;
    description: string;
    additionalInfo: {
        key: string;
        value: string;
        ar_different?: string;
        en_different?: string;
    }[];
    reviews: IReview[] | undefined;
    tags: string[] | undefined;
    orderQuantity?: number;
    brand: string;
    brand_id?: string|number;
    top_rated?: boolean;
    sell_count?: number;
    offerDate?: {
        startDate: string;
        endDate: string;
    }
    seo_description?: string;
    seo_keywords?: string;
}

export type TProducts = (IProduct | IProductResponse) | (IProduct | IProductResponse)[]