import type {ICategory} from "@/types/category-d-t";
import type {IProduct} from "@/types/product-d-t";
import type {ICategoryResponse} from "@/types/category-response-d-t";

export interface IProductResponse {
    id: string;
    name: string;
    ar_name?: string;
    en_name?: string;
    description: string;
    seo_description?: string;
    seo_keywords?: string;
    label: string;
    slug: string;
    brand: string;
    brand_id: string;
    price: string;
    calculated_price: string;
    calculated_full_price: string;
    price_after_discount?: string;
    discount: number|string;
    rating: string|number;
    imageUrl: string;
    quantity: string | undefined;
    categories?: {
        data: (ICategory|ICategoryResponse)[];
    } | undefined;
    different: string;
    ar_different?: string;
    en_different?: string;
    differents: {
        data: IProduct[];
    };
    images: {
        data: string[];
    };
}