import {useLocaleStore} from "@/pinia/useLocaleStore";
import type {ILocale} from "@/types/locale-d-t";
import type {Ref} from "vue";
import type {I18nHeadMetaInfo} from "@nuxtjs/i18n";
export * from "./convertCategoryFilterResponse";
export * from "./convertBrandFilterResponse";
export * from "./topCategories";
export * from "./scrollToTop";
export * from "./devRefresh";
export * from "./config";
export * from "./arrayWrap";
export * from "./auth";
export * from "./Axios";
export * from "./cutString";
export * from "./objectExcept";
export * from "./objectOnly";
export * from "./toSocialLinks";

export const getLocaleIso = (): string => {
    return useLocaleStore().selectedLanguageIso();
};

export const getArabicLocale = (): ILocale|undefined => {
    const result = useLocaleStore().locales()?.find((l: ILocale|string) => (typeof l === 'string' ? (l as string) : (l as ILocale)?.code) === 'ar');

    return (typeof result === 'string' ? {iso: result, code: result} : result) as ILocale|undefined
};

export const getUseLocaleHead = (): Ref<I18nHeadMetaInfo> => useLocaleHead({
    addDirAttribute: true,
    identifierAttribute: 'id',
    addSeoAttributes: true
});

export const getHeadDir = (): string => getUseLocaleHead().value?.htmlAttrs?.dir;

export const isArabic = (): boolean|undefined => [getArabicLocale()?.iso, getArabicLocale()?.code].includes(getUseLocaleHead().value?.htmlAttrs?.lang);
export const isNotArabic = (): boolean|undefined => !isArabic();
