import type {ISelect} from "@/types/select-d-t";

export const loadCountriesData = async () => {
    const defaultValue = useState('default_country_id', () => '' as string);
    const data = useState('countries_select', () => [] as ISelect[]);

    const {
        data: dataCountries,
        pending: pendingCountries,
        error: errorCountries,
        refresh: refreshCountries
    } = await useLazyAsyncData(
        `countries_data_select`,
        (): Promise<ISelect[]> => $axios.get("countries").then((res) => {
            defaultValue.value = String(res.data.default);
            data.value = res.data.data;

            return res.data.data;
        }),
        {
            // default: () => data.value,
            // watch: [props],
            immediate: true,
            server: false
        }
    );

    return {
        data,
        default: defaultValue,
        async: dataCountries,
        refresh: refreshCountries,
        pending: pendingCountries,
        error: errorCountries
    }
};

export const unloadCountriesData = () => {
    clearNuxtState([
        // 'default_country_id',
        'countries_select',
        'governorates_select',
        'cities_select',
        'current_country_id',
        'current_governorate_id'
    ])

    return;
};