export async function scrollToTop() {
    return new Promise<void>((resolve) => {
        const scrollHandler = () => {
            if (window.scrollY === 0) {
                window.removeEventListener('scroll', scrollHandler);
                resolve();
            }
        };

        window.addEventListener('scroll', scrollHandler);
        if (window.scrollY === 0) {
            window.removeEventListener('scroll', scrollHandler);
            resolve();
        } else {
            window.scrollTo({top: 0, behavior: 'auto'});
        }
    });
}