import type {Composer, ExportedGlobalComposer} from "vue-i18n";
import type {LocaleObject} from "@nuxtjs/i18n";
import type {ISiteSettings} from "@/types/site-settings-d-t";
import type {IAxios} from "@/types/axios-d-t";
import type {NuxtI18nRoutingCustomProperties} from "@nuxtjs/i18n/dist/runtime/types";
import type {ILocale} from "@/types/locale-d-t";
import type {ITranslation} from "@/types/translation-d-t";

declare module "*.vue" {
    import Vue from 'vue'
    export default Vue
}

declare module '#app' {
    interface NuxtApp {
        $i18n: ExportedGlobalComposer & Composer & NuxtI18nRoutingCustomProperties<LocaleObject[]>;
        $settings: ISiteSettings;
        $axios: IAxios;
        $locales: ILocale[];
        $locale: string;
        $baseUrl: string;
        $translations: ITranslation;
    }
}
